---
title: 'Vorstellung: RDLViewer'
author: Sven
type: post
date: 2016-11-10T21:59:43+00:00
url: /2016/11/10/vorstellung-rdlviewer/
categories:
  - 'C#'

---
Hier möchte ich mal den RDLViewer vorstellen.  
Im Prinzip macht er nichts anderes als Lokale SQL Server Reports mit integrierter Datenquelle im XML Format anzuzeigen.  
Entwickelt wurde das ganze ursprünglich mal als Kostenfreie Reporting-Alternative für diverse interne Tools.  
Ziel des ganzen war dabei möglichst einfach Berichtsdaten ausgeben &#8211; und aus diesen einen Bericht erstellen und anzeigen zu können.

Das ganze sieht dann z.B. mit dem Beispiel-Bericht (einer kleinen Rechnung) wie folgt aus:  
![img1](/img/2016-11-10-vorstellung-rdlviewer/1_testbericht.jpg)

<!--more-->

Hierbei wird die Datei &#8222;test.rdlv&#8220; mit der Reportviewer.exe gestartet. Dies kann entweder dadurch erreicht werden das die Datei direkt auf die Exe gezogen wird, sie als Parameter übergeben wird &#8211; oder indem man dem System sagt das *.rdlv Dateien Standardmäßig mit der RDLViewer.exe gestartet werden sollen.  
Die &#8222;test.rdlv&#8220; dient lediglich als Datenquelle und beinhaltet &#8222;nur&#8220; ein DataSet welches in diesem Fall wie folgt definiert ist:

```xml
<?xml version="1.0" standalone="yes"?>
<BerichtsDaten>
  <Kopfdaten>
    <Name>Rechnung</Name>
    <Bank>Bremer MusterBank eG</Bank>
    <BLZ>90063548</BLZ>
    <KTO>274562 </KTO>
    <FIRMA>Musterpraxis Aua GmbH</FIRMA>
    <STRASSE>Musterstraße 5</STRASSE>
    <PLZOrt>2048 Bitstadt</PLZOrt>
    <RGAdresse>Maximilia Musterpatient
Musterweg 32
1024 Bithausen</RGAdresse>
  </Kopfdaten>
  <Posten>
    <art_nr>4711</art_nr>
    <bezeichnung>Untersuchung</bezeichnung>
    <betrag_netto>100,00</betrag_netto>
    <betrag_brutto>119,00</betrag_brutto>
  </Posten>
  <Posten>
    <art_nr>4800</art_nr>
    <bezeichnung>Behandlung</bezeichnung>
    <betrag_netto>1000,00</betrag_netto>
    <betrag_brutto>1190,00</betrag_brutto>
  </Posten>
  <Posten>
    <art_nr>4913</art_nr>
    <bezeichnung>Medikamentoese Medikamente</bezeichnung>
    <betrag_netto>50,00</betrag_netto>
    <betrag_brutto>53,00</betrag_brutto>
  </Posten>
  <Posten>
    <art_nr>5199</art_nr>
    <bezeichnung>Krankheit feststellen</bezeichnung>
    <betrag_netto>99,00</betrag_netto>
    <betrag_brutto>110,00</betrag_brutto>
  </Posten>
  <Posten>
    <art_nr>5600</art_nr>
    <bezeichnung>Krankenschein ausfuellen</bezeichnung>
    <betrag_netto>10,00</betrag_netto>
    <betrag_brutto>11,90</betrag_brutto>
  </Posten>
</BerichtsDaten>
```

Der passende RDL Bericht dafür liegt im Unterverzeichnis &#8222;Reports&#8220; mit dem Namen &#8222;test.rdl&#8220;.  
Sollte dieser Report nicht existieren &#8211; z.b. im Falle einer neuen Datenquelle, welche man dem RDLViewer übergibt &#8211; würde dieser folgende Ausgabe anzeigen:  
![img2](/img/2016-11-10-vorstellung-rdlviewer/2_neuerbericht.jpg)

Hier werden dann unter anderem Infos angezeigt wo der SQl Server Report Builder herunter geladen werden kann, wie das Verzeichnis für die RDL Reports lautet und welchen Namen der report bekommen würde (analog zur Datenquelle &#8222;test.rdlv&#8220; wäre dies auch &#8222;test.rdl&#8220;).  
Außerdem kann man auch gleich einen leeren Bericht mit dem Inhalt der Datenquelle Erstellen lassen und im Standard-Programm für RDL Dateien öffnen lassen.  
Dies würde im SQL Server Report Builder dann so aussehen:  
![img3](/img/2016-11-10-vorstellung-rdlviewer/3_neuerbericht.jpg)

Jetzt könnte man direkt eine Tabelle aus dem Dataset &#8222;Posten&#8220; in den Bericht einfügen, würde dann so aussehen:  
![img4](/img/2016-11-10-vorstellung-rdlviewer/4_neuerbericht.jpg)

Und diesen Bericht dann in der Vorschau ausführen &#8211; Ergebnis: alle Daten aus der Posten-Tabelle sind in der Tabelle zu sehen:  
![img5](/img/2016-11-10-vorstellung-rdlviewer/5_neuerbericht.jpg)

Wenn wir diesen RDL-Bericht nun speichern und unsere Datei &#8222;test.rdlv&#8220; über den RDV-Viewer öffnen, dann wird dieser Bericht genau so angezeigt:  
![img6](/img/2016-11-10-vorstellung-rdlviewer/6_neuerbericht.jpg)

Das war es auch schon 🙂

Der Quellcode ist unter GitHub verfügbar: <https://github.com/svenschmalle/RDLViewer>  
Die Aktuelle version (1.3) gibt es ebenfalls als zip unter GitHub zum Download:  
<https://github.com/svenschmalle/RDLViewer/releases/download/1.3.0.0/RDLViewer_1.3.zip>

 [1]: http://frickelblog.de/wp-content/uploads/2016/11/1_testbericht.jpg
 [2]: http://frickelblog.de/wp-content/uploads/2016/11/2_neuerbericht.jpg
 [3]: http://frickelblog.de/wp-content/uploads/2016/11/3_neuerbericht.jpg
 [4]: http://frickelblog.de/wp-content/uploads/2016/11/4_neuerbericht.jpg
 [5]: http://frickelblog.de/wp-content/uploads/2016/11/5_neuerbericht.jpg
 [6]: http://frickelblog.de/wp-content/uploads/2016/11/6_neuerbericht.jpg