+++
title = "SQL Server localdb – Mehrere Versionen verwalten"
author = "Sven"
template = "page.html"
date = 2017-01-06T14:16:59+00:00
[taxonomies]
tags = ["MSSQL"]
+++

Vor einiger Zeit habe ich [HIER][1] schon mal etwas über SQLServer 2012 localdb geschrieben.  
Mittlerweile gibt es von der localdb installation mehrere Versionen (Aktuell: 2012 / 2014 / 2016).

Um Herauszufinden welche Versionen auf dem System installiert sind, kann der Befehl &#8222;sqllocaldb versions&#8220; genutzt werden:

```
E:\Programme\cmder>sqllocaldb versions
Microsoft SQL Server 2012 (11.0.5058.0)
Microsoft SQL Server 2014 (12.0.4100.1)
Microsoft SQL Server 2016 (13.0.1601.5)
Microsoft SQL Server 2017 (14.0.1000.169)
```

Standardmäßig wird eine neue Datenbank-Instanz über den &#8222;Create&#8220;-Befehl mit der aktuelleren Version angelegt.  
Möchte man eine Instanz mit der 2012er Version anlegen, geht dies so:

```
E:\Programme\cmder>sqllocaldb create SQL2012 11.0.5058.0
LocalDB instance "SQL2012" created with version 11.0.5058.0.
```

Und für die 2014er Version so:

```
E:\Programme\cmder>sqllocaldb create SQL2014 12.0.4100.1
LocalDB instance "SQL2014" created with version 12.0.4100.1.
```

Ebenfalls kann so auch explizit eine 2016er Instanz angelegt werden:

```
E:\Programme\cmder>sqllocaldb create SQL2016 13.0.1601.5
LocalDB instance "SQL2016" created with version 13.0.1601.5.
```

Oder für eine 2017er Instanz:

```
E:\Programme\cmder>sqllocaldb create SQL2017 14.0.1000.169
LocalDB instance "SQL2017" created with version 14.0.1000.169.
```

<!--more-->

Hier noch einmal die Komplette SQL Server localdb Hilfe:

```
E:\Programme\cmder>sqllocaldb -?
Microsoft (R) SQL Server Express LocalDB Command Line Tool
Version 11.0.5058.0
Copyright (c) Microsoft Corporation.  All rights reserved.

Usage: SqlLocalDB operation [parameters...]

Operations:

 -?
 Prints this information

 create|c "instance name" [version-number] [-s]
    Creates a new LocalDB instance with a specified name and version
    If the [version-number] parameter is omitted, it defaults to the
    SqlLocalDB product version.
    -s starts the new LocalDB instance after it's created

 delete|d "instance name"
    Deletes the LocalDB instance with the specified name

 start|s "instance name"
    Starts the LocalDB instance with the specified name

 stop|p "instance name" [-i|-k]
    Stops the LocalDB instance with the specified name,
    after current queries finish
    -i request LocalDB instance shutdown with NOWAIT option
    -k kills LocalDB instance process without contacting it

 share|h ["owner SID or account"] "private name" "shared name"
    Shares the specified private instance using the specified shared name.
    If the user SID or account name is omitted, it defaults to current user.

 unshare|u "shared name"
    Stops the sharing of the specified shared LocalDB instance.

 info|i
    Lists all existing LocalDB instances owned by the current user
    and all shared LocalDB instances.

 info|i "instance name"
    Prints the information about the specified LocalDB instance.

 versions|v
    Lists all LocalDB versions installed on the computer.

 trace|t on|off
    Turns tracing on and off

SqlLocalDB treats spaces as delimiters. It is necessary to surround
instance names that contain spaces and special characters with quotes.
For example:
SqlLocalDB create "My LocalDB Instance"
```

 [1]: http://frickelblog.de/2013/01/24/sql-server-2012-localdb/